
import java.net.HttpURLConnection
import java.net.URL
import java.io.OutputStreamWriter

object KhilaadiXProSDK {
    
    fun createOrder(customerMobile: String, userToken: String, amount: String, orderId: String, redirectUrl: String, remark1: String, remark2: String) {
        val url = URL("https://khilaadixpro.shop/api/create-order")
        with(url.openConnection() as HttpURLConnection) {
            // Setting up the request
            requestMethod = "POST"
            doOutput = true
            setRequestProperty("Content-Type", "application/x-www-form-urlencoded")

            // Preparing the data
            val postData = "customer_mobile=\${customerMobile}&user_token=\${userToken}&amount=\${amount}&order_id=\${orderId}&redirect_url=\${redirectUrl}&remark1=\${remark1}&remark2=\${remark2}"

            // Sending the data
            OutputStreamWriter(outputStream).use { it.write(postData) }

            // Handling the response
            println("Response Code: \$responseCode")
            if (responseCode == HttpURLConnection.HTTP_OK) {
                inputStream.bufferedReader().use {
                    val response = it.readText()
                    println("Response: \$response")
                }
            } else {
                println("Request failed")
            }
        }
    }
}

fun main() {
    // Test the SDK
    KhilaadiXProSDK.createOrder("8145344963", "e8d2a2f1ac98d41d3b7422fd11ab98fa", "1", "8787772321800", "https://khilaadixpro.shop", "testremark", "testremark2")
}
