<?php
include "header.php";

// SQL query to count rows
$sql = "SELECT COUNT(*) AS count FROM reports WHERE mobile = '$mobile'";

// Execute the query
$result = $conn->query($sql);

if ($result === false) {
    $rowCount = 0;
} else {
    // Fetch the result
    $row = $result->fetch_assoc();

    // Get the count from the result
    $rowCount = $row['count'];
}

$expiryDate = $userdata['expiry'];
$today = date('Y-m-d'); // Get today's date in 'YYYY-MM-DD' format

if (strtotime($expiryDate) >= strtotime($today)) {
    $status = "Active";
} else {
    $status = "Expired";
}

?>

    <style>
        .quick-actions-modern {
            background: transparent;
            border-radius: 18px;
            padding: 32px 0 28px 0;
            margin-bottom: 32px;
            box-shadow: none;
        }
        .quick-actions-modern-header {
            margin-bottom: 22px;
            padding-left: 8px;
        }
        .quick-actions-modern-header h2 {
            font-size: 1.6rem;
            font-weight: 700;
            margin: 0 0 4px 0;
            color: var(--text-primary);
            letter-spacing: -1px;
        }
        .quick-actions-modern-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(210px, 1fr));
            gap: 22px;
        }
        .qa-modern-card {
            display: flex;
            align-items: center;
            border-radius: 18px;
            padding: 20px 18px;
            color: #fff;
            text-decoration: none;
            box-shadow: 0 4px 24px 0 rgba(0,0,0,0.10);
            transition: transform 0.18s cubic-bezier(.4,2,.6,1), box-shadow 0.18s;
            position: relative;
            overflow: hidden;
            min-height: 90px;
        }
        .qa-modern-card:hover {
            transform: scale(1.045) translateY(-2px);
            box-shadow: 0 8px 32px 0 rgba(0,0,0,0.18);
            z-index: 2;
        }
        .qa-modern-icon {
            width: 48px;
            height: 48px;
            border-radius: 10px; /* Changed from 50% to 10px for rectangular rounded corners */
            background: rgba(255,255,255,0.13);
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 1.7rem;
            margin-right: 18px;
            color: #fff;
            box-shadow: 0 2px 8px rgba(0,0,0,0.10);
            flex-shrink: 0;
        }
        .qa-modern-content {
            display: flex;
            flex-direction: column;
            justify-content: center;
        }
        .qa-modern-title {
            font-size: 1.13rem;
            font-weight: 600;
            margin-bottom: 4px;
            color: #fff;
            letter-spacing: -0.5px;
        }
        .qa-modern-desc {
            font-size: 0.98rem;
            color: #f3f3f3;
            opacity: 0.93;
        }
        /* Unique gradients for each card */
        .qa-gradient-blue {
            background: linear-gradient(135deg, #3a8dde 0%, #005bea 100%);
        }
        .qa-gradient-green {
            background: linear-gradient(135deg, #43e97b 0%, #38f9d7 100%);
        }
        .qa-gradient-orange {
            background: linear-gradient(135deg, #f7971e 0%, #ffd200 100%);
            color: #4a2f00;
        }
        .qa-gradient-purple {
            background: linear-gradient(135deg, #a770ef 0%, #f6d365 100%);
            color: #3d2461;
        }
        .qa-gradient-pink {
            background: linear-gradient(135deg, #ff5858 0%, #f09819 100%);
        }
        /* Add/override gradients for indigo, amber, and rose */
        .qa-gradient-indigo {
            /* Use API Docs color (purple gradient) */
            background: linear-gradient(135deg, #a770ef 0%, #f6d365 100%) !important;
            color: #3d2461 !important;
        }
        .qa-gradient-amber {
            /* Use Pending Payment Amount color (gradient-green-lime) */
            background: linear-gradient(135deg, #00b09b 0%, #96c93d 100%) !important;
            color: #fff !important;
        }
        .qa-gradient-rose {
            background: linear-gradient(135deg, #ff5e62 0%, #ff9966 100%) !important;
            color: #fff !important;
        }
        /* Ensure text is white except for orange/purple for contrast */
        .qa-gradient-orange .qa-modern-title,
        .qa-gradient-orange .qa-modern-desc,
        .qa-gradient-purple .qa-modern-title,
        .qa-gradient-purple .qa-modern-desc {
            color: #4a2f00 !important;
        }
        @media (max-width: 900px) {
            .quick-actions-modern-grid {
                grid-template-columns: repeat(auto-fit, minmax(150px, 1fr));
                gap: 13px;
            }
            .qa-modern-card {
                padding: 14px 8px;
            }
            .qa-modern-icon {
                width: 36px;
                height: 36px;
                font-size: 1.2rem;
                margin-right: 10px;
                border-radius: 8px; /* Also update for mobile */
            }
        }
        
                .gradient-black {
            background: linear-gradient(135deg, #000000, #2C3E50) !important;
            border: 1px solid rgba(255, 255, 255, 0.1) !important;
        }
        
        /* New vibrant gradients */
        .gradient-red-orange {
            background: linear-gradient(90deg, #FF416C 0%, #FF4B2B 100%) !important;
        }
        
        .gradient-purple-blue {
            background: linear-gradient(90deg, #6a11cb 0%, #2575fc 100%) !important;
        }
        
        .gradient-green-lime {
            background: linear-gradient(135deg, #00b09b, #96c93d) !important;
        }
        
        .gradient-teal-lime {
            background: linear-gradient(135deg, #02c2ab, #a6d94f) !important;
        }
        
        /* Existing gradient styles with !important */
        .gradient-emerald {
            background: linear-gradient(135deg, #2ecc71, #27ae60) !important;
        }
        
        .gradient-aqua {
            background: linear-gradient(135deg, #00b4d8, #0077b6) !important;
        }
        
        .gradient-amber {
            background: linear-gradient(135deg, #ffb300, #ff8c00) !important;
        }
        
        .gradient-orange {
            background: linear-gradient(135deg, #ff9f1c, #ffbf69) !important;
        }
        
        .gradient-rose {
            background: linear-gradient(135deg, #f72585, #b5179e) !important;
        }
        
        .gradient-red {
            background: linear-gradient(135deg, #ef233c, #d90429) !important;
        }
        
        .gradient-blue {
            background: linear-gradient(135deg, #4895ef, #4361ee) !important;
        }
        
        .gradient-indigo {
            background: linear-gradient(135deg, #7209b7, #560bad) !important;
        }
        
        .gradient-royal {
            background: linear-gradient(135deg, #4A68BD, #38527B) !important;
        }
        
        .gradient-teal {
            background: linear-gradient(135deg, #20B2AA, #008B8B) !important;
        }
        
        .gradient-expired {
            background: linear-gradient(135deg, #f72585, #7209b7) !important;
        }
        
        .gradient-deactivated {
            background: linear-gradient(135deg, #d90429, #ef233c) !important;
        }

        /* Glass morphism header */
        .glass-panel {
            background: rgba(255, 255, 255, 0.85);
            backdrop-filter: blur(10px);
            border-radius: var(--border-radius);
            border: 1px solid rgba(255, 255, 255, 0.5);
            box-shadow: 0 8px 32px rgba(0, 0, 0, 0.08);
            padding: 24px;
            margin-bottom: 24px;
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 20px;
            max-width: 1400px;
            margin: 20px auto;
        }
        
        .header-left {
            display: flex;
            align-items: center;
        }
        
        .animated-logo {
            height: auto;
            width: 100px;
            margin-right: 24px;
            animation: pulse 2s infinite alternate;
            filter: drop-shadow(0 0 8px rgba(79, 70, 229, 0.4));
        }
        
        .welcome-title {
            font-size: 28px;
            font-weight: 700;
            margin: 0;
            color: var(--dark-gray);
        }
        
        .company-name {
            background: linear-gradient(to right, #4338CA, #9333EA);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
        }
        
        .date-expiry {
            display: flex;
            align-items: center;
            flex-wrap: wrap;
            gap: 8px;
            margin-top: 8px;
            color: var(--primary-light);
            font-size: 14px;
        }
        
        .today-date {
            font-weight: 500;
        }
        
        .plan-text {
            color: #6B7280;
        }
        
        .expiry-date {
            font-weight: 600;
            color: var(--primary);
        }
        
        .status-indicator {
            width: 10px;
            height: 10px;
            border-radius: 50%;
            display: inline-block;
            margin-left: 6px;
        }
        
        .status-indicator.active {
            background-color: var(--success);
            box-shadow: 0 0 8px rgba(16, 185, 129, 0.5);
            animation: blink 1.5s infinite;
        }
        
        .status-indicator.expired {
            background-color: var(--danger);
            box-shadow: 0 0 8px rgba(239, 68, 68, 0.5);
            animation: blink 1.5s infinite; /* Added animation for expired state */
        }
        
        .header-right {
            display: flex;
            align-items: center;
        }
        
        
        
        .dashboard00{
            margin: 0px;
            border-radius: 8px;
        }
        
        @media (min-width: 768px) {
            .dashboard00 {
            margin: 40px;
            border-radius: 8px;
            }
        }
        
        .ibox {
            border-radius: 8px;
        }
    </style>
    
    
    
<!-- START PAGE CONTENT-->
<div class="page-content fade-in-up">
    
        <div class="dashboard-header glass-panel">
        <div class="header-left">
            <img src="<?php echo $site_settings['logo_url']; ?>" alt="Company Logo" class="dashboard-logo animated-logo">
            <div class="header-content">
                <h1 class="welcome-title">Welcome, <span class="company-name"><?php echo $userdata['company']; ?></span></h1>
                <div class="date-expiry">
                    <span class="today-date"><?php echo date('Y-m-d'); ?></span>
                    <span class="divider">•</span>
                    <span class="plan-text">Plan Expiry: </span>
                    <span class="expiry-date"><?php echo htmlspecialchars($userdata['expiry'], ENT_QUOTES, 'UTF-8'); ?></span>
                    <span class="status-indicator active"></span>
                </div>
            </div>
        </div>
    </div>
    
    <div class="row dashboard00">
        <div class="col-lg-3 col-md-6">
            <div class="ibox gradient-green-lime color-white widget-stat">
                <div class="ibox-body">
                    <h2 class="m-b-5 font-strong">₹<?php echo number_format($todaysuccesspayment["amt"], 2); ?></h2>
                    <div class="m-b-5">Received Today (Amount)</div><i class=" widget-stat-icon"><svg xmlns="http://www.w3.org/2000/svg" width="29" height="29" fill="currentColor" class="bi bi-arrow-left-right" viewBox="0 0 16 16">
                            <path fill-rule="evenodd" d="M1 11.5a.5.5 0 0 0 .5.5h11.793l-3.147 3.146a.5.5 0 0 0 .708.708l4-4a.5.5 0 0 0 0-.708l-4-4a.5.5 0 0 0-.708.708L13.293 11H1.5a.5.5 0 0 0-.5.5m14-7a.5.5 0 0 1-.5.5H2.707l3.147 3.146a.5.5 0 1 1-.708.708l-4-4a.5.5 0 0 1 0-.708l4-4a.5.5 0 1 1 .708.708L2.707 4H14.5a.5.5 0 0 1 .5.5" />
                        </svg></i>
                    <div><i class="fa fa-level-up m-r-5"></i><small>100% higher</small></div>
                </div>
            </div>
        </div>
        <div class="col-lg-3 col-md-6">
            <div class="ibox gradient-purple-blue color-white widget-stat">
                <div class="ibox-body">
                    <h2 class="m-b-5 font-strong"><?php echo number_format($todayallpayment["amt"]) ?></h2>
                    <div class="m-b-5">Success Payments Today (Count)</div><i class=" widget-stat-icon"><svg xmlns="http://www.w3.org/2000/svg" width="29" height="29" fill="currentColor" class="bi bi-send-check" viewBox="0 0 16 16">
                            <path d="M15.964.686a.5.5 0 0 0-.65-.65L.767 5.855a.75.75 0 0 0-.124 1.329l4.995 3.178 1.531 2.406a.5.5 0 0 0 .844-.536L6.637 10.07l7.494-7.494-1.895 4.738a.5.5 0 1 0 .928.372zm-2.54 1.183L5.93 9.363 1.591 6.602z" />
                            <path d="M16 12.5a3.5 3.5 0 1 1-7 0 3.5 3.5 0 0 1 7 0m-1.993-1.679a.5.5 0 0 0-.686.172l-1.17 1.95-.547-.547a.5.5 0 0 0-.708.708l.774.773a.75.75 0 0 0 1.174-.144l1.335-2.226a.5.5 0 0 0-.172-.686" />
                        </svg></i>
                    <div><i class="fa fa-level-up m-r-5"></i><small>99.9% higher</small></div>
                </div>
            </div>
        </div>
        <div class="col-lg-3 col-md-6">
            <div class="ibox qa-gradient-pink color-white widget-stat">
                <div class="ibox-body">
                    <h2 class="m-b-5 font-strong">₹<?php echo number_format($todaypendingpayment["amt"], 2); ?></h2>
                    <div class="m-b-5">Pending Today (Amount)</div><i class=" widget-stat-icon"><svg xmlns="http://www.w3.org/2000/svg" width="29" height="29" fill="currentColor" class="bi bi-clock-history" viewBox="0 0 16 16">
                            <path d="M8.515 1.019A7 7 0 0 0 8 1V0a8 8 0 0 1 .589.022zm2.004.45a7 7 0 0 0-.985-.299l.219-.976q.576.129 1.126.342zm1.37.71a7 7 0 0 0-.439-.27l.493-.87a8 8 0 0 1 .979.654l-.615.789a7 7 0 0 0-.418-.302zm1.834 1.79a7 7 0 0 0-.653-.796l.724-.69q.406.429.747.91zm.744 1.352a7 7 0 0 0-.214-.468l.893-.45a8 8 0 0 1 .45 1.088l-.95.313a7 7 0 0 0-.179-.483m.53 2.507a7 7 0 0 0-.1-1.025l.985-.17q.1.58.116 1.17zm-.131 1.538q.05-.254.081-.51l.993.123a8 8 0 0 1-.23 1.155l-.964-.267q.069-.247.12-.501m-.952 2.379q.276-.436.486-.908l.914.405q-.24.54-.555 1.038zm-.964 1.205q.183-.183.35-.378l.758.653a8 8 0 0 1-.401.432z" />
                            <path d="M8 1a7 7 0 1 0 4.95 11.95l.707.707A8.001 8.001 0 1 1 8 0z" />
                            <path d="M7.5 3a.5.5 0 0 1 .5.5v5.21l3.248 1.856a.5.5 0 0 1-.496.868l-3.5-2A.5.5 0 0 1 7 9V3.5a.5.5 0 0 1 .5-.5" />
                        </svg></i>
                    <div><i class="fa fa-level-up m-r-5"></i><small>12% higher</small></div>
                </div>
            </div>
        </div>
        <div class="col-lg-3 col-md-6">
            <div class="ibox gradient-red-orange color-white widget-stat">
                <div class="ibox-body">
                    <h2 class="m-b-5 font-strong">₹<?php echo number_format($todaysuccesspayment["amt"], 2); ?></h2>
                    <div class="m-b-5">Today Settlement (Amount)</div><i class="widget-stat-icon"><svg xmlns="http://www.w3.org/2000/svg" width="29" height="29" fill="currentColor" class="bi bi-send-dash" viewBox="0 0 16 16">
                            <path d="M15.964.686a.5.5 0 0 0-.65-.65L.767 5.855a.75.75 0 0 0-.124 1.329l4.995 3.178 1.531 2.406a.5.5 0 0 0 .844-.536L6.637 10.07l7.494-7.494-1.895 4.738a.5.5 0 1 0 .928.372zm-2.54 1.183L5.93 9.363 1.591 6.602z" />
                            <path d="M16 12.5a3.5 3.5 0 1 1-7 0 3.5 3.5 0 0 1 7 0m-5.5 0a.5.5 0 0 0 .5.5h3a.5.5 0 0 0 0-1h-3a.5.5 0 0 0-.5.5" />
                        </svg></i>
                    <div><i class="fa fa-level-up m-r-5"></i><small>99.9% higher</small></div>
                </div>
            </div>
        </div>
        <div class="col-lg-3 col-md-6">
            <div class="ibox gradient-red-orange color-white widget-stat">
                <div class="ibox-body">
                    <h2 class="m-b-5 font-strong"><?php echo htmlspecialchars($userdata['expiry'], ENT_QUOTES, 'UTF-8'); ?></h2>
                    <div class="m-b-5">Plan Expire Date</div><i class="widget-stat-icon"><svg xmlns="http://www.w3.org/2000/svg" width="29" height="29" fill="currentColor" class="bi bi-calendar2-check" viewBox="0 0 16 16">
                            <path d="M10.854 8.146a.5.5 0 0 1 0 .708l-3 3a.5.5 0 0 1-.708 0l-1.5-1.5a.5.5 0 0 1 .708-.708L7.5 10.793l2.646-2.647a.5.5 0 0 1 .708 0" />
                            <path d="M3.5 0a.5.5 0 0 1 .5.5V1h8V.5a.5.5 0 0 1 1 0V1h1a2 2 0 0 1 2 2v11a2 2 0 0 1-2 2H2a2 2 0 0 1-2-2V3a2 2 0 0 1 2-2h1V.5a.5.5 0 0 1 .5-.5M2 2a1 1 0 0 0-1 1v11a1 1 0 0 0 1 1h12a1 1 0 0 0 1-1V3a1 1 0 0 0-1-1z" />
                            <path d="M2.5 4a.5.5 0 0 1 .5-.5h10a.5.5 0 0 1 .5.5v1a.5.5 0 0 1-.5.5H3a.5.5 0 0 1-.5-.5z" />
                        </svg></i>
                    <div><i class="fa fa-level-up m-r-5"></i><small>45% higher</small></div>
                </div>
            </div>
        </div>


        <div class="col-lg-3 col-md-6">
            <div class="ibox gradient-green-lime color-white widget-stat">
                <div class="ibox-body">
                    <h2 class="m-b-5 font-strong"><?php echo $rowCount ?></h2>
                    <div class="m-b-5">Reported Transactions (Count)</div><i class="widget-stat-icon"><svg xmlns="http://www.w3.org/2000/svg" width="29" height="29" fill="currentColor" class="bi bi-hourglass-split" viewBox="0 0 16 16">
                            <path d="M2.5 15a.5.5 0 1 1 0-1h1v-1a4.5 4.5 0 0 1 2.557-4.06c.29-.139.443-.377.443-.59v-.7c0-.213-.154-.451-.443-.59A4.5 4.5 0 0 1 3.5 3V2h-1a.5.5 0 0 1 0-1h11a.5.5 0 0 1 0 1h-1v1a4.5 4.5 0 0 1-2.557 4.06c-.29.139-.443.377-.443.59v.7c0 .213.154.451.443.59A4.5 4.5 0 0 1 12.5 13v1h1a.5.5 0 0 1 0 1zm2-13v1c0 .537.12 1.045.337 1.5h6.326c.216-.455.337-.963.337-1.5V2zm3 6.35c0 .701-.478 1.236-1.011 1.492A3.5 3.5 0 0 0 4.5 13s.866-1.299 3-1.48zm1 0v3.17c2.134.181 3 1.48 3 1.48a3.5 3.5 0 0 0-1.989-3.158C8.978 9.586 8.5 9.052 8.5 8.351z" />
                        </svg></i>
                    <div><i class="fa fa-level-up m-r-5"></i><small>18% higher</small></div>
                </div>
            </div>
        </div>
        <div class="col-lg-3 col-md-6">
            <div class="ibox gradient-purple-blue color-white widget-stat">
                <div class="ibox-body">
                    <h2 class="m-b-5 font-strong"><?php echo htmlspecialchars($status, ENT_QUOTES, 'UTF-8'); ?></h2>
                    <div class="m-b-5">Account Status</div><i class="widget-stat-icon"><svg xmlns="http://www.w3.org/2000/svg" width="29" height="29" fill="currentColor" class="bi bi-person-check" viewBox="0 0 16 16">
                            <path d="M12.5 16a3.5 3.5 0 1 0 0-7 3.5 3.5 0 0 0 0 7m1.679-4.493-1.335 2.226a.75.75 0 0 1-1.174.144l-.774-.773a.5.5 0 0 1 .708-.708l.547.548 1.17-1.951a.5.5 0 1 1 .858.514M11 5a3 3 0 1 1-6 0 3 3 0 0 1 6 0M8 7a2 2 0 1 0 0-4 2 2 0 0 0 0 4" />
                            <path d="M8.256 14a4.5 4.5 0 0 1-.229-1.004H3c.001-.246.154-.986.832-1.664C4.484 10.68 5.711 10 8 10q.39 0 .74.025c.226-.341.496-.65.804-.918Q8.844 9.002 8 9c-5 0-6 3-6 4s1 1 1 1z" />
                        </svg></i>
                    <div><i class="fa fa-level-up m-r-5"></i><small>99% higher</small></div>
                </div>
            </div>
        </div>
        <div class="col-lg-3 col-md-6">
            <div class="ibox qa-gradient-pink color-white widget-stat">
                <div class="ibox-body">
                    <h2 class="m-b-5 font-strong">₹<?php echo number_format($todayfail["amt"], 2); ?></h2>
                    <div class="m-b-5">Failed Today (Amount)</div><i class="widget-stat-icon"><svg xmlns="http://www.w3.org/2000/svg" width="29" height="29" fill="currentColor" class="bi bi-send-exclamation" viewBox="0 0 16 16">
                            <path d="M15.964.686a.5.5 0 0 0-.65-.65L.767 5.855a.75.75 0 0 0-.124 1.329l4.995 3.178 1.531 2.406a.5.5 0 0 0 .844-.536L6.637 10.07l7.494-7.494-1.895 4.738a.5.5 0 1 0 .928.372zm-2.54 1.183L5.93 9.363 1.591 6.602z" />
                            <path d="M12.5 16a3.5 3.5 0 1 0 0-7 3.5 3.5 0 0 0 0 7m.5-5v1.5a.5.5 0 0 1-1 0V11a.5.5 0 0 1 1 0m0 3a.5.5 0 1 1-1 0 .5.5 0 0 1 1 0" />
                        </svg></i>
                    <div><i class="fa fa-level-down m-r-5"></i><small>-12% Lower</small></div>
                </div>
            </div>
        </div>
    </div>




    <div class="row" style="margin-top:80px">
        <div class="col-lg-12 col-md-12">
            <div class="ibox bg-primary color-white widget-stat">
                <div class="ibox-body">
                    <center>
                        <h2 class="m-b-5 font-strong">Pay0 Payments API v1.0</h2>
                    </center>
                    <i class=" widget-stat-icon" style="line-height:60px !important"><svg xmlns="http://www.w3.org/2000/svg" width="29" height="29" fill="currentColor" class="bi bi-clock-history" viewBox="0 0 16 16">
                            <path d="M8.515 1.019A7 7 0 0 0 8 1V0a8 8 0 0 1 .589.022zm2.004.45a7 7 0 0 0-.985-.299l.219-.976q.576.129 1.126.342zm1.37.71a7 7 0 0 0-.439-.27l.493-.87a8 8 0 0 1 .979.654l-.615.789a7 7 0 0 0-.418-.302zm1.834 1.79a7 7 0 0 0-.653-.796l.724-.69q.406.429.747.91zm.744 1.352a7 7 0 0 0-.214-.468l.893-.45a8 8 0 0 1 .45 1.088l-.95.313a7 7 0 0 0-.179-.483m.53 2.507a7 7 0 0 0-.1-1.025l.985-.17q.1.58.116 1.17zm-.131 1.538q.05-.254.081-.51l.993.123a8 8 0 0 1-.23 1.155l-.964-.267q.069-.247.12-.501m-.952 2.379q.276-.436.486-.908l.914.405q-.24.54-.555 1.038zm-.964 1.205q.183-.183.35-.378l.758.653a8 8 0 0 1-.401.432z" />
                            <path d="M8 1a7 7 0 1 0 4.95 11.95l.707.707A8.001 8.001 0 1 1 8 0z" />
                            <path d="M7.5 3a.5.5 0 0 1 .5.5v5.21l3.248 1.856a.5.5 0 0 1-.496.868l-3.5-2A.5.5 0 0 1 7 9V3.5a.5.5 0 0 1 .5-.5" />
                        </svg></i>
                </div>
            </div>
        </div>
    </div>


    <style>
        .visitors-table tbody tr td:last-child {
            display: flex;
            align-items: center;
        }

        .visitors-table .progress {
            flex: 1;
        }

        .visitors-table .progress-parcent {
            text-align: right;
            margin-left: 10px;
        }
    </style>

</div>

<!-- END PAGE CONTENT-->
<footer class="page-footer">
    <div class="font-13">2025 © <b>PaglaUPI</b> - All rights reserved.</div>
    <div class="to-top"><i class="fa fa-angle-double-up"></i></div>
</footer>
</div>
</div>

<!-- BEGIN PAGA BACKDROPS-->
<div class="sidenav-backdrop backdrop"></div>

<!-- END PAGA BACKDROPS-->
<!-- CORE PLUGINS-->
<script src="./assets/vendors/jquery/dist/jquery.min.js" type="text/javascript"></script>
<script src="./assets/vendors/popper.js/dist/umd/popper.min.js" type="text/javascript"></script>
<script src="./assets/vendors/bootstrap/dist/js/bootstrap.min.js" type="text/javascript"></script>
<script src="./assets/vendors/metisMenu/dist/metisMenu.min.js" type="text/javascript"></script>
<script src="./assets/vendors/jquery-slimscroll/jquery.slimscroll.min.js" type="text/javascript"></script>
<!-- PAGE LEVEL PLUGINS-->
<script src="./assets/vendors/chart.js/dist/Chart.min.js" type="text/javascript"></script>
<script src="./assets/vendors/jvectormap/jquery-jvectormap-2.0.3.min.js" type="text/javascript"></script>
<script src="./assets/vendors/jvectormap/jquery-jvectormap-world-mill-en.js" type="text/javascript"></script>
<script src="./assets/vendors/jvectormap/jquery-jvectormap-us-aea-en.js" type="text/javascript"></script>
<!-- CORE SCRIPTS-->
<script src="assets/js/app.min.js" type="text/javascript"></script>
<!-- PAGE LEVEL SCRIPTS-->
<script src="./assets/js/scripts/dashboard_1_demo.js" type="text/javascript"></script>
</body>

</html>