<?php
//every 1min

// Define the base directory constant
define('PROJECT_ROOT', realpath(dirname(__FILE__)) . '/../');

// Securely include files using the PROJECT_ROOT constant
include PROJECT_ROOT . 'pages/dbFunctions.php';
include PROJECT_ROOT . 'auth/config.php';

date_default_timezone_set("Asia/Kolkata");
// Assuming $conn is defined in the auth config




///webhook sender


// Fetching data from orders table where status is SUCCESS and webhook_sent is 'no'
$query = "SELECT user_id, order_id, remark1, remark2,amount, status,customer_mobile FROM orders WHERE status = 'SUCCESS' AND webhook_sent = 'no'";
$result = mysqli_query($conn, $query);

// Check for errors in the query execution
if (!$result) {
    echo "no pending webhook";
}

// Loop through the fetched orders
while ($row = mysqli_fetch_assoc($result)) {
    $user_id = $row['user_id']; // Get user ID
    $order_id = $row['order_id']; // Get order ID
    $remark1 = $row['remark1']; // Get remark1
    $remark2 = $row['remark2']; // Get remark2
    $status = $row['status']; // Get status
    $amount1=$row['amount']; // Get Amount
    $cxmobile=$row['customer_mobile']; //customber mobile

    // Fetching callback_url from users table based on user ID
    $query_user = "SELECT callback_url FROM users WHERE id = '$user_id'";
    $result_user = mysqli_query($conn, $query_user);

    

    // Fetch callback_url if user exists
    if (mysqli_num_rows($result_user) > 0) {
        $user_row = mysqli_fetch_assoc($result_user);
        $callback_url = $user_row['callback_url']; // Get callback_url


      
        // Data to be sent
        $postData = array(
            'status' => $status,
            'order_id' => $order_id,
            'customer_mobile' =>$cxmobile,
            'amount'=>$amount1,
            'remark1' => $remark1,
            'remark2' => $remark2
        );

        // Initialize cURL
        $ch = curl_init($callback_url);

        // Set cURL options
        curl_setopt_array($ch, [
            CURLOPT_RETURNTRANSFER => true, // This will not output the response
            CURLOPT_POST => true,
            CURLOPT_POSTFIELDS => http_build_query($postData)
        ]);

        // Execute the POST request
        $response = curl_exec($ch);

    
       

        // Update webhook_sent status to 'yes' in the orders table
        $update_query = "UPDATE orders SET webhook_sent = 'yes' WHERE order_id = '$order_id'";
        $update_result = mysqli_query($conn, $update_query);


        // Close cURL session
        curl_close($ch);
    }
}



//delete older payment link

// Current time
$payzero1current_time = date("Y-m-d H:i:s");

// Calculate time threshold (30 minutes ago)
$payzero1time_threshold = date("Y-m-d H:i:s", strtotime('-30 minutes'));

// SQL query to delete rows with created_at more than 30 minutes older than current time
$payzero1sql = "DELETE FROM payment_links WHERE created_at <= '$payzero1time_threshold'";

if ($conn->query($payzero1sql) === TRUE) {
    $deleted_rows = $conn->affected_rows;
    echo "$deleted_rows rows deleted successfully from payment_links.\n";
} else {
   // echo "Error deleting rows: " . $conn->error . "\n";
}