require 'net/http'
require 'json'

class KhilaadixproSdk
  BASE_URL = 'https://khilaadixpro.shop/api/check-order-status'

  def initialize(user_token)
    @user_token = user_token
  end

  def check_order_status(order_id)
    uri = URI(BASE_URL)
    params = { 'user_token' => @user_token, 'order_id' => order_id }
    uri.query = URI.encode_www_form(params)

    response = Net::HTTP.get_response(uri)

    if response.is_a?(Net::HTTPSuccess)
      return JSON.parse(response.body)
    else
      raise "Failed to check order status: #{response.code} - #{response.body}"
    end
  end
end
